/** @file   AlienFireballBullet.cpp
 * @brief   Implementation of AlienFireballBullet class.
 * @version $Revision: 1.3 $
 * @date    $Date: 2006/04/25 17:59:26 $
 * @author  Tomi Lamminsaari
 */

#include "AlienFireballBullet.h"
#include "www_map.h"
#include "gameanims.h"
#include "AnimId.h"
using namespace eng2d;


namespace WeWantWar {

///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
AlienFireballBullet::AlienFireballBullet( GameObject* aShooter, const Vec2D& aPos ) :
  Bullet( aShooter, Bullet::EAlienFireball, aPos )
{
  iAnimation = GameAnims::findAnimation( AnimId::KBulletAlienFireball );
  iFlags |= KTrails;
}



/** Destructor.
 */
AlienFireballBullet::~AlienFireballBullet()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

/** Draws this bullet
 */
void AlienFireballBullet::redraw( BITMAP* aBitmap ) const
{
  int posX = iPosition.intX() - Map::scrollX;
  int posY = iPosition.intY() - Map::scrollY;
  
  AnimFrame f = iAnimation.currentFrame();
  RLE_SPRITE* bulletGfx = f.asRleSprite();
  posX -= bulletGfx->w / 2;
  posY -= bulletGfx->h / 2;
  SetBlendFunction( f.iFrameBlend, f.iFrameAlpha );
  draw_trans_rle_sprite( aBitmap, bulletGfx, posX, posY );
}

};  // end of namespace
